/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class VWWorkClassListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_blankIcon = null;
    private ImageIcon m_localWorkClassIcon = null;
    private ImageIcon m_serverWorkClassIcon = null;

    public VWWorkClassListCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_blankIcon = VWImageLoader.createImageIcon("blank.gif");
            this.m_localWorkClassIcon = VWImageLoader.createImageIcon("workflowCollection.gif");
            this.m_serverWorkClassIcon = VWImageLoader.createImageIcon("server.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            this.applyComponentOrientation(list.getComponentOrientation());
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null && value instanceof VWWorkClassProxy) {
                VWWorkClassProxy workClassProxy = (VWWorkClassProxy)value;
                switch (workClassProxy.getType()) {
                    case 0: {
                        this.setIcon(this.m_localWorkClassIcon);
                        break;
                    }
                    case 1: {
                        this.setIcon(this.m_serverWorkClassIcon);
                    }
                }
                this.setText(workClassProxy.getName());
            } else if (value != null && value instanceof String) {
                this.setIcon(this.m_blankIcon);
                this.setText((String)value);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

